#include <GUIConstantsEx.au3>
#include <GuiRichEdit.au3>
#include <WindowsConstants.au3>

Example()

Func Example()
	Local $hGui, $hRichEdit, $hRichEdit2, $hRichEdit3, $hRichEdit123
	Local $iMsg
	$hGui = GUICreate("Example (" & StringTrimRight(@ScriptName, 4) & ")", 1300, 350, -1, -1)

	#Region Create all RichEdit controls
	$hRichEdit1 = _GUICtrlRichEdit_Create($hGui, "This is a first test.", 10, 10, 300, 220, _
			BitOR($ES_MULTILINE, $WS_VSCROLL, $ES_AUTOVSCROLL))
	_GUICtrlRichEdit_AppendText($hRichEdit1, @CRLF & "This is more text" & @CRLF)

	$hRichEdit2 = _GUICtrlRichEdit_Create($hGui, "This is a second test.", 320, 10, 300, 220, _
			BitOR($ES_MULTILINE, $WS_VSCROLL, $ES_AUTOVSCROLL))
	_GUICtrlRichEdit_AppendText($hRichEdit2, @CRLF & "This is more text" & @CRLF)

	$hRichEdit3 = _GUICtrlRichEdit_Create($hGui, "This is a third test.", 630, 10, 300, 220, _
			BitOR($ES_MULTILINE, $WS_VSCROLL, $ES_AUTOVSCROLL))
	_GUICtrlRichEdit_AppendText($hRichEdit3, @CRLF & "This is more text" & @CRLF)

	$hRichEdit123 = _GUICtrlRichEdit_Create($hGui, "This is a combined test.", 940, 10, 300, 220, _
			BitOR($ES_MULTILINE, $WS_VSCROLL, $ES_AUTOVSCROLL))
	_GUICtrlRichEdit_AppendText($hRichEdit123, @CRLF & @CRLF)
	#EndRegion Create all RichEdit controls

	; Copying $hRichEdit1 to $hRichEdit123
	_GUICtrlRichEdit_CopyAllToRichEdit($hRichEdit1, $hRichEdit123)

	; Copying $hRichEdit2 to $hRichEdit123
	_GUICtrlRichEdit_CopyAllToRichEdit($hRichEdit2, $hRichEdit123)

	; Copying $hRichEdit3 to $hRichEdit123
	_GUICtrlRichEdit_CopyAllToRichEdit($hRichEdit3, $hRichEdit123)

	GUISetState(@SW_SHOW)

	While True
		$iMsg = GUIGetMsg()
		Select
			Case $iMsg = $GUI_EVENT_CLOSE
				_GUICtrlRichEdit_Destroy($hRichEdit1) ; needed unless script crashes
				_GUICtrlRichEdit_Destroy($hRichEdit2) ; needed unless script crashes
				_GUICtrlRichEdit_Destroy($hRichEdit3) ; needed unless script crashes
				_GUICtrlRichEdit_Destroy($hRichEdit123) ; needed unless script crashes
				; GUIDelete() 	; is OK too
				Exit
		EndSelect
	WEnd
EndFunc   ;==>Example

Func _GUICtrlRichEdit_CopyAllToRichEdit(ByRef $hSourceRichEdit, ByRef $hDestinationRichEdit)

	; check for current selection in source control
	Local $aSelection = _GUICtrlRichEdit_GetSel($hSourceRichEdit)

	; select all contents in source control
	_GUICtrlRichEdit_SetSel($hSourceRichEdit, 0, -1)

	; select selected contents in source control
	_GUICtrlRichEdit_Copy($hSourceRichEdit)

	; paste content to destination control
	_GUICtrlRichEdit_Paste($hDestinationRichEdit)

	; revert back selection in source control
	_GUICtrlRichEdit_SetSel($hSourceRichEdit, $aSelection[0], $aSelection[1])

EndFunc   ;==>_GUICtrlRichEdit_CopyAllToRichEdit
